/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.equipments;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.xkmc.l2library.util.math.MathHelper;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class GolemEquipmentItem
extends Item {
    protected static final EnumMap<EquipmentSlot, UUID> UUID = new EnumMap(EquipmentSlot.class);
    private final EquipmentSlot slot;
    private final Supplier<EntityType<?>> type;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public GolemEquipmentItem(Item.Properties properties, EquipmentSlot slot, Supplier<EntityType<?>> type, Consumer<ImmutableMultimap.Builder<Attribute, AttributeModifier>> attr) {
        super(properties);
        this.slot = slot;
        this.type = type;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        attr.accept((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder);
        this.defaultModifiers = builder.build();
    }

    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public boolean isFor(EntityType<?> type) {
        return this.type.get() == type;
    }

    public Multimap<Attribute, AttributeModifier> getGolemModifiers(ItemStack stack, @Nullable Entity entity, EquipmentSlot slot) {
        if (this.slot == slot && (entity == null || this.type.get() == entity.m_6095_())) {
            return this.getDefaultGolemModifiers(stack, slot);
        }
        return ImmutableMultimap.of();
    }

    protected Multimap<Attribute, AttributeModifier> getDefaultGolemModifiers(ItemStack stack, EquipmentSlot slot) {
        return this.defaultModifiers;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)MGLangData.GOLEM_EQUIPMENT.get(this.type.get().m_20676_().m_6881_().m_130940_(ChatFormatting.GOLD)));
        Multimap<Attribute, AttributeModifier> multimap = this.getGolemModifiers(stack, null, this.slot);
        if (multimap.isEmpty()) {
            return;
        }
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)("item.modifiers." + this.slot.m_20751_())).m_130940_(ChatFormatting.GRAY));
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier attr = (AttributeModifier)entry.getValue();
            double val = attr.m_22218_();
            double disp = attr.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attr.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? val * 10.0 : val) : val * 100.0;
            if (val > 0.0) {
                list.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attr.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(disp), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                continue;
            }
            if (!(val < 0.0)) continue;
            list.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attr.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(disp *= -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
        }
    }

    static {
        for (EquipmentSlot e : EquipmentSlot.values()) {
            UUID.put(e, MathHelper.getUUIDFromString((String)("modulargolems:metalgolem_" + e.m_20751_())));
        }
    }
}

